import React, { useEffect, useState } from "react";

const STORAGE_KEY = "puzzleport_run_history_v1";

export default function Leaderboard() {
  const [board, setBoard] = useState([]);

  useEffect(() => {
    try {
      const raw = JSON.parse(localStorage.getItem(STORAGE_KEY) || "[]");
      setBoard(raw);
    } catch {
      setBoard([]);
    }
  }, []);

  return (
    <div className="min-h-screen p-8">
      <div className="max-w-3xl mx-auto glass p-6 rounded-2xl">
        <h2 className="text-2xl font-semibold">Leaderboard</h2>
        {board.length === 0 ? (
          <p className="text-white/70 mt-3">
            No scores yet — finish a run to save your result.
          </p>
        ) : (
          <ol className="mt-4 space-y-2">
            {board.map((r, i) => (
              <li
                key={i}
                className="p-3 bg-white/6 rounded flex justify-between items-center"
              >
                <div>
                  <div className="font-semibold">{r.name}</div>
                  <div className="text-sm text-white/70">
                    {new Date(r.date).toLocaleString()}
                  </div>
                </div>
                <div className="text-right">
                  <div className="font-semibold">{r.correct} ✅</div>
                  <div className="text-sm text-white/70">
                    {r.wrong} ❌ • {r.time}s
                  </div>
                </div>
              </li>
            ))}
          </ol>
        )}
      </div>
    </div>
  );
}
